package music;

public class Musician {
	
	protected String name;
	protected String instrument;
	
	public Musician(String name, String instrument) {
		super();
		this.name = name;
		this.instrument = instrument;
	}
	public Musician() {
	}
	
	public void printDetails() {
		System.out.println("Musician: ");
		System.out.println('\t' + this.name);
		System.out.println('\t' + this.instrument);
	}
	
	@Override
	public String toString() {
		return this.name + ": " + this.instrument;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Musician) {
			Musician m = (Musician) obj;
			if (m.getInstrument().equals(this.instrument) && m.getName().equals(this.name)) {
				return true;
			}
		}
		return false;
	}
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getInstrument() {
		return instrument;
	}
	public void setInstrument(String instrument) {
		this.instrument = instrument;
	}
	
	

}
